<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:variable name='resource' select='document("../../ide/documents/titoresource.xml")/resource'/>

	<xsl:variable name='comboboxes' select='$resource/comboboxes'/>



	<!-- Template for combo box -->

	<xsl:template name='comboBox'>

		<!-- These attributes have the highest priority, you should provide them if you generate combo box in XSLT -->

		<xsl:param name='id'/>				<!-- SELECT element ID -->

		<xsl:param name='style'/>			<!-- "DropDown" - the text portion is editable; "DropDownList" - The text portion is readonly -->

		<xsl:param name='status'/>			<!-- "enabled", "disabled" or "hidden" -->

		<xsl:param name='selected'/>		<!-- Selected option value: "index=2" or "value=345" or "text=Option Text" -->

		<xsl:param name='width'/>			<!-- Unit can be pixel or percentage, includes the width of button image -->

		<xsl:param name='shortcut'/>		<!-- Same syntax as menu and toolbar -->

		<xsl:param name='name'/>			<!-- The label of combo box -->

		<xsl:param name='tooltip'/>			<!-- The tooltip of combo box -->

		<xsl:param name='src'/>				<!-- The source node description of options, format: <document id>#<pattern of the node>, ex.: project#/workspace/comboboxes/combobox[@id='ComboSearch'] -->

		<xsl:param name='autosave'/>		<!-- Save options automatically when combo box is closing if source is set, value: 1 or "true" -->



		<!-- The <combobox> node in data source XML document, the attributes in this node have the medium priority -->

		<xsl:param name='comboBoxNode'/>



		<!-- The <combobox> node in resource definition document, the attributes in this node have the lowest priority -->

		<xsl:param name='comboBoxDefine'/>



		<!-- Get all the necessary attributes -->

		<xsl:variable name='cbID'>

			<xsl:choose>

				<xsl:when test='$id'><xsl:value-of select='$id'/></xsl:when>

				<xsl:when test='$comboBoxNode'><xsl:value-of select='$comboBoxNode/@comboboxid'/></xsl:when>

				<xsl:when test='$comboBoxDefine'><xsl:value-of select='$comboBoxDefine/@id'/></xsl:when>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='comboBoxResource' select='$comboboxes/combobox[@id = $cbID]'/>



		<xsl:variable name='cbStyle'>

			<xsl:choose>

				<xsl:when test='$style'><xsl:value-of select='$style'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@style'><xsl:value-of select='$comboBoxNode/@style'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@style'><xsl:value-of select='$comboBoxDefine/@style'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@style'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbStatus'>

			<xsl:choose>

				<xsl:when test='$status'><xsl:value-of select='$status'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@status'><xsl:value-of select='$comboBoxNode/@status'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@status'><xsl:value-of select='$comboBoxDefine/@status'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@status'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbSelected'>

			<xsl:choose>

				<xsl:when test='$selected'><xsl:value-of select='$selected'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@selected'><xsl:value-of select='$comboBoxNode/@selected'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@selected'><xsl:value-of select='$comboBoxDefine/@selected'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@selected'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbWidth'>

			<xsl:choose>

				<xsl:when test='$width'><xsl:value-of select='$width'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@width'><xsl:value-of select='$comboBoxNode/@width'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@width'><xsl:value-of select='$comboBoxDefine/@width'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@width'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbShortcut'>

			<xsl:choose>

				<xsl:when test='$shortcut'><xsl:value-of select='$shortcut'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@shortcut'><xsl:value-of select='$comboBoxNode/@shortcut'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@shortcut'><xsl:value-of select='$comboBoxDefine/@shortcut'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@shortcut'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbName'>

			<xsl:choose>

				<xsl:when test='$name'><xsl:value-of select='$name'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@name'><xsl:value-of select='$comboBoxNode/@name'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@name'><xsl:value-of select='$comboBoxDefine/@name'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@name'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbTooltip'>

			<xsl:choose>

				<xsl:when test='$tooltip'><xsl:value-of select='$tooltip'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@tooltip'><xsl:value-of select='$comboBoxNode/@tooltip'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@tooltip'><xsl:value-of select='$comboBoxDefine/@tooltip'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@tooltip'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbSource'>

			<xsl:choose>

				<xsl:when test='$src'><xsl:value-of select='$src'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@src'><xsl:value-of select='$comboBoxNode/@src'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@src'><xsl:value-of select='$comboBoxDefine/@src'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@src'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<xsl:variable name='cbAutoSave'>

			<xsl:choose>

				<xsl:when test='$autosave'><xsl:value-of select='$autosave'/></xsl:when>

				<xsl:when test='$comboBoxNode and $comboBoxNode/@autosave'><xsl:value-of select='$comboBoxNode/@autosave'/></xsl:when>

				<xsl:when test='$comboBoxDefine and $comboBoxDefine/@autosave'><xsl:value-of select='$comboBoxDefine/@autosave'/></xsl:when>

				<xsl:otherwise><xsl:value-of select='$comboBoxResource/@autosave'/></xsl:otherwise>

			</xsl:choose>

		</xsl:variable>



		<table id="{$cbID}_table" titoclass="comboBox" src="{$cbSource}" autosave="{$cbAutoSave}" comboboxstyle="{$cbStyle}" status="{$cbStatus}" shortcut="{$cbShortcut}" name="{$cbName}" title="{$cbTooltip}" cellpadding="0" cellspacing="0" border="0">

			<xsl:attribute name='class'>combobox_common combobox_<xsl:value-of select='$cbStatus'/><xsl:if test='not($cbStatus)'>enabled</xsl:if></xsl:attribute>

			<xsl:if test='$cbWidth and string-length($cbWidth) > 0'><xsl:attribute name='style'>width:<xsl:value-of select='$cbWidth'/>;</xsl:attribute></xsl:if>

			<tr>

				<td class="combobox_input">

					<input id="{$cbID}_input" comboboxid="{$cbID}" type="text" size="1">

						<xsl:choose>

							<xsl:when test='$cbStyle = "DropDownList"'>

								<xsl:attribute name='readonly'>1</xsl:attribute>

								<xsl:attribute name='style'>cursor:default;</xsl:attribute>

							</xsl:when>

							<xsl:when test='$cbStyle = "DropDown"'>

								<xsl:attribute name='style'>cursor:text;</xsl:attribute>

							</xsl:when>

						</xsl:choose>

					</input>



					<xsl:if test='$cbSelected and string-length($cbSelected) > 0'>

						<xsl:call-template name='comboBoxSelect'>

							<xsl:with-param name='id' select='$cbID'/>

							<xsl:with-param name='selected' select='$cbSelected'/>

							<xsl:with-param name='comboBoxNode' select='$comboBoxNode'/>

							<xsl:with-param name='comboBoxDefine' select='$comboBoxDefine'/>

							<xsl:with-param name='comboBoxResource' select='$comboBoxResource'/>

<!--							<xsl:with-param name='comboBoxDefine'>

								<xsl:choose>

									<xsl:when test='$comboBoxDefine'><xsl:copy-of select='$comboBoxDefine'/></xsl:when>

									<xsl:otherwise><xsl:copy-of select='$comboBoxResource'/></xsl:otherwise>

								</xsl:choose>

							</xsl:with-param> -->

						</xsl:call-template>

					</xsl:if>

				</td>

				<td class="combobox_arrow">

					<div><img id="{$cbID}_image" src="../apt/images/commandlistdown.gif"/></div>

				</td>

			</tr>

		</table>



	</xsl:template>



	<xsl:template name='comboBoxSelect'>

		<xsl:param name='id'/>				<!-- SELECT element ID -->

		<xsl:param name='selected'/>		<!-- Selected option value: "index=2" or "value=345" or "text=Option Text" -->

		<xsl:param name='comboBoxNode'/>		<!-- The <combobox> node in XML document if exists -->

		<xsl:param name='comboBoxDefine'/>

		<xsl:param name='comboBoxResource'/>



		<xsl:variable name='selectedName' select='substring-before($selected, "=")'/>

		<xsl:variable name='selectedValue' select='substring-after($selected, "=")'/>



		<select class="combobox" id="{$id}" tabindex="-1" style="display:none;">

			<xsl:if test='$selectedName = "index" or $selectedName = "value" or $selectedName = "text"'>

				<xsl:attribute name='{$selectedName}'><xsl:value-of select='$selectedValue'/></xsl:attribute>

			</xsl:if>

			<xsl:call-template name='comboBoxOptions'>

				<xsl:with-param name='id' select='$id'/>

				<xsl:with-param name='selected' select='$selected'/>

				<xsl:with-param name='comboBoxNode' select='$comboBoxNode'/>

				<xsl:with-param name='comboBoxDefine' select='$comboBoxDefine'/>

				<xsl:with-param name='comboBoxResource' select='$comboBoxResource'/>

			</xsl:call-template>

		</select>



	</xsl:template>



	<xsl:template match='combobox/option'>

		<xsl:param name='selectedName'/>

		<xsl:param name='selectedValue'/>



		<option>

			<xsl:apply-templates select='@value'/>

			<xsl:if test='($selectedName = "text" and $selectedValue = text()) or ($selectedName = "value" and $selectedValue = @value) or ($selectedName = "index" and $selectedValue = position() - 1)'>

				<xsl:attribute name='selected'>1</xsl:attribute>

			</xsl:if>

			<xsl:value-of select='text()'/>

		</option>



	</xsl:template>



</xsl:stylesheet>

